/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.alertsimulator;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.vistara.sdk.alert.AlertAPIClient;
import com.vistara.sdk.dto.alert.Alert;
import com.vistara.sdk.dto.device.Device;
import com.vistara.sdk.dto.integrations.Attribute;
import com.vistara.sdk.dto.integrations.MapAttributeValue;
import com.vistara.sdk.integrations.IntegrationAPIClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NectarSimulator {
    private static final Logger logger = LoggerFactory.getLogger(NectarSimulator.class);
    private static final String VISTARA_BASE_URI = "https://192.168.56.121";
    private static final String API_KEY = "{key}";
    private static final String API_SECRET = "{secret}";
    private static final int alertPostInterval = 2;
    private static Map<String, String> clientUniqueIdMap = new HashMap<String, String>();
    private String tenantId = "msp_6";
    private String instIntgId = "INTG-ffb11004-b6ed-4ab3-a70b-082ac0353438";
    private static final ArrayList<String> rigIds = new ArrayList();

    private void getIntgMappings() throws Exception {
        IntegrationAPIClient cl = new IntegrationAPIClient(this.tenantId, "NECTAR", null);
        cl.setOAUTH2Authentication(API_KEY, API_SECRET);
        String respMap = cl.getIntgMappings(this.instIntgId, "Alert%20Client%20UniqueId");
        HashMap map = (HashMap)new Gson().fromJson(respMap, new TypeToken<HashMap<String, String>>(){}.getType());
        String str = (String)map.get("status_message");
        List mappings = (List)new Gson().fromJson(str, new TypeToken<List<Attribute>>(){}.getType());
        for (Attribute attr : mappings) {
            List<MapAttributeValue> mapAttr = attr.getAttrValues();
            for (MapAttributeValue mapping : mapAttr) {
                clientUniqueIdMap.put(mapping.getThirdPartyAttrValue(), mapping.getAttrValue());
                rigIds.add(mapping.getThirdPartyAttrValue());
            }
        }
    }

    private String getClientNameByRigId(String rigName) throws Exception {
        return clientUniqueIdMap.get(rigName);
    }

    private Alert prepareAlertObject() {
        Alert vistaraAlert = new Alert();
        Random r = new Random();
        int randInt = r.nextInt();
        vistaraAlert.setSubject("Test alert from Nectar simulator -> val -> " + randInt);
        vistaraAlert.setDescription("Test description from Nectar simulator with random value -" + randInt);
        vistaraAlert.setCurrentState("CRITICAL");
        vistaraAlert.setClientTechnology("NECTAR");
        vistaraAlert.setServiceName("Test service Name - " + randInt);
        vistaraAlert.setApp("nectar");
        Device alertDevice = new Device();
        alertDevice.setHostName("Test Host" + randInt);
        alertDevice.setIpAddress(this.getRandomIPAddr());
        alertDevice.setMacAddress(this.randomMACAddress());
        vistaraAlert.setDevice(alertDevice);
        return vistaraAlert;
    }

    private String getRandomIPAddr() {
        Random r = new Random();
        return r.nextInt(256) + "." + r.nextInt(256) + "." + r.nextInt(256) + "." + r.nextInt(256);
    }

    private String randomMACAddress() {
        Random rand = new Random();
        byte[] macAddr = new byte[6];
        rand.nextBytes(macAddr);
        macAddr[0] = (byte)(macAddr[0] & 0xFFFFFFFE);
        StringBuilder sb = new StringBuilder(18);
        for (byte b : macAddr) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private String getRandomRigName() {
        Random rand = new Random();
        return rigIds.get(rand.nextInt(rigIds.size()));
    }

    public void invokeSimulator() throws Exception {
        logger.debug("Entered into Simulator");
        final NectarSimulator nectar = new NectarSimulator();
        logger.debug("going to fetch mappings");
        nectar.getIntgMappings();
        logger.debug("Fetch Mappings completed");
        final AlertAPIClient apiClient = AlertAPIClient.getInstance();
        apiClient.setApiBaseURI(VISTARA_BASE_URI);
        apiClient.setOAUTH2Authentication(API_KEY, API_SECRET);
        Runnable helloRunnable = new Runnable(){

            @Override
            public void run() {
                String status = null;
                try {
                    status = apiClient.createAlert(nectar.getClientNameByRigId(nectar.getRandomRigName()), nectar.prepareAlertObject());
                    logger.error("Alert posted successfully with status " + status);
                    System.out.println("Alert pushed");
                }
                catch (Exception e) {
                    logger.error("Alert posted successfully");
                    e.printStackTrace();
                }
            }
        };
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleAtFixedRate(helloRunnable, 0L, 2L, TimeUnit.SECONDS);
    }
}

